<!DOCTYPE html>
<html>
	<head>
    	<meta charset="utf-8" />
        <link rel="stylesheet" href="css/design.css" /> 
	    <script src="javascript/mesFonctions.js"> </script>
		
		<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.3.1/jquery.min.js"></script>
		<script src="https://code.highcharts.com/highcharts.js"></script>
		<script src="https://code.highcharts.com/modules/exporting.js"></script>

		<script> var chart; // global </script>
    	<title>Production en temps réel</title>
	</head>

	<body>
		<?php include("includes/entete.php"); ?>
	    <div id="conteneur">
		<?php include("includes/menu2.php"); ?>
		<article>
		<div id="container" style="min-width: 310px; height: 400px; margin: 0 auto"></div>
		<script>
		/**
 * demande la dernière donnée au serveur, ajoute cette donnée au graphe. Cette action est répétée toutes les 5 secondes
 * to request again
 */
function requestData() {
	setInterval(function() {
		$.ajax({
			url: 'majTempsReel.php',
			success: function(point) {
				var series = chart.series[0],
					shift = series.data.length > 50; // décalage du graphe si il y a plus de 50 points
					// call it again after one second
					//setTimeout(requestData, 1000);  
					chart.series[0].addPoint(point, true, shift); 
			},
			cache: false
		});
	}, 5000); //action répétée toutes les 5 sec
}


$(document).ready(function() {
    chart = new Highcharts.Chart({
        chart: {
            renderTo: 'container',
			backgroundColor: 'lavender',
            defaultSeriesType: 'spline',
            events: {
                load: requestData
            },
        },
        title: {
            text: 'Evolution de la puissance en temps réel',
			style: {
				color: 'darkblue',
				fontSize:'20px'
			}
        },
        xAxis: {
            type: 'datetime',
            tickPixelInterval: 100,
            maxZoom: 20 * 1000,
			lineColor: 'black',
            lineWidth: 1
        },
        yAxis: {
            minPadding: 0.2,
            maxPadding: 0.2,
			lineColor: 'black',
			lineWidth: 1,
            title: {
                text: 'Valeur',
                margin: 80
            },
			title: {
                text: 'Puissance ( en kWh )',
				style: {
					color: 'darkblue',
					fontSize:'20px'
				}
            }
        },
		plotOptions: {
			series: {
				marker: {
					enabled: false
				}
			}
		},
		rangeSelector: {
            selected: 1
        },
        series: [{
            name: 'Valeurs aléatoires',
            data: [],
			tooltip: {
                valueDecimals: 2
            }
        }]
    });        
});
		</script>
		</article>              
	</div>
	<?php include("includes/pieddepage.php"); ?>
</body>
</html>
